<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\ValidationRequest;
use App\ProfileSekolah;
use Alert;
use Carbon\Carbon;
use Image;
use File;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Helper;
use Illuminate\Support\Facades\Storage;

class ProfileSekolahController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $data = ProfileSekolah::get();
        return view('pages.be.profile-sekolah', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update_logo(ValidationRequest $request){
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            if(file_exists("assets/files/logo/".$profile->logo)){
                File::delete('assets/files/logo/'.$profile->logo);
                if(file_exists("assets/files/logo/thumbnail/".$profile->logo)){
                    File::delete('assets/files/logo/thumbnail/'.$profile->logo);
                }
            }

            if(!File::isDirectory('assets/files/logo')){
                File::makeDirectory('assets/files/logo', 0755, true, true);
            }
            if(!File::isDirectory('assets/files/logo/thumbnail')) {
                File::makeDirectory('assets/files/logo/thumbnail', 0755, true, true);
            }

            $file = $request->file('logo');
            $filename = strtolower('logo-'.Helper::acakstring(8)).'.'.$request->logo->extension();
            $path = "assets/files/logo/".$filename;
            $uploaded = Helper::resizeImageAR($file, $path, 1000, 1000);
            if($uploaded){
                $thumbnailsource = "assets/files/logo/".$filename;
                $thumbnailpath = "assets/files/logo/thumbnail/". $filename;
                Helper::createThumbnail($thumbnailsource, $thumbnailpath, 225, 225);
            }
            //create backupdata
            // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/logo/", $path, $filename);
            // Storage::disk('SFTP')->putFileAs(Helper::web_config('npsn')."/assets/files/logo/thumbnail", $thumbnailpath, $filename);
            $data = array('logo' => $filename, 'updated_at' => Carbon::now('Asia/Jakarta'));
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate logo sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti logo sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function update_main_color(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'main_color' => $request->main_color,
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate warna utama website!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti warna utama website!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function update_nama_sekolah(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'nama_sekolah' => $request->nama_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate nama sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti nama sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_deskripsi_sekolah(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'deskripsi_sekolah' => $request->deskripsi_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate deskripsi sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti deskripsi sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_facebook(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'facebook' => $request->facebook,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate facebook sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti fb sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_twitter(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'twitter' => $request->twitter,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate twitter sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti twitter sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_instagram(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'instagram' => $request->instagram,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate instagram sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti instagram sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_nama_tautan_1(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'nama_tautan_1' => $request->nama_tautan_1,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate nama tautan 1 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti nama link 1!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_nama_tautan_2(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'nama_tautan_2' => $request->nama_tautan_2,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate nama tautan 2 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti nama link 2!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_nama_tautan_3(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'nama_tautan_3' => $request->nama_tautan_3,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate nama tautan 3 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti nama link 3!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_tautan_1(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'tautan_1' => $request->tautan_1,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate tautan 1 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti link 1!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_tautan_2(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'tautan_2' => $request->tautan_2,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate tautan 2 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti link 2!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_tautan_3(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'tautan_3' => $request->tautan_3,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate tautan 3 sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti link 3!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_telepon_sekolah(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'telepon_sekolah' => $request->telepon_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate telepon sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti telepon sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_email_sekolah(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'email_sekolah' => $request->email_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate email sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti email sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
    public function update_alamat_sekolah(Request $request)
    {
        try {
            $id = $request->id;
            $profile = ProfileSekolah::findOrFail($id);
            $data = array(
                'alamat_sekolah' => $request->alamat_sekolah,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $profile->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate alamat sekolah!");
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengganti alamat sekolah!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
