<?php

namespace App\Http\Controllers;

use App\RunningText;
use Illuminate\Http\Request;
use App\Helper;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Yajra\DataTables\Facades\DataTables;

class RunningTextController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('pages.be.running_text');
    }

    function json()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        $data = RunningText::orderBy('id', 'DESC')->get();
        return DataTables::of($data)
                    ->addIndexColumn()
                    ->editColumn('options', function($row){
                        $count = RunningText::count();
                        if($count <= 1)
                        {
                            $disabled = "disabled";
                        }else{
                            $disabled = "";
                        }

                        $edit = route('running.edit', $row->id);
                        $btn = "&emsp;<a href='{$edit}' class='btn btn-sm btn-warning modal-show edit' title='Form Edit Running Text: {$row->title}'><i class='fa fa-pencil'></i></a> <button type='button' class='btn btn-sm btn-danger' id='destroy' {$disabled} data-id='{$row->id}'><i class='fa fa-trash'></i></button>";
                        return $btn;
                    })
                    ->editColumn('status', function($row){
                        if($row->status == 1){
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' checked ><span></span></label>";
                        }else{
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' ><span></span></label>";
                        }
                        return $status;
                    })
                    ->editColumn('created_at', function($row){
                        return $row->created_at != NULL ? \Helper::tgl_indo($row->created_at) : "-";
                    })
                    ->editColumn('updated_at', function($row){
                        return $row->updated_at != NULL ? \Helper::tgl_indo($row->updated_at) : "-";
                    })
                    ->rawColumns(['options', 'status'])
                    ->toJson();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $model = new RunningText();
        return view('pages.be.form_runningtext', compact('model'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'title' => 'required|string',
                'text' => 'required|string'
            ],[
                'title.required' => 'Title harus diisi!',
                'title.string' => 'Title diperbolehkan hanya string!',
                'text.required' => 'Text harus diisi!',
                'text.string' => 'Text diperbolehkan hanya string!'
            ]);

            $data = new RunningText();
            $data->title = $request->title;
            $data->text = $request->text;
            $data->save();
            \Helper::log(\Auth::user()->username, "Menambah runningtext : ".$data->title);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menambah running text!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\RunningText  $runningText
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $model = RunningText::findOrFail($id);
        return view('pages.be.form_runningtext', compact('model'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\RunningText  $runningText
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'title' => 'required|string',
                'text' => 'required|string'
            ],[
                'title.required' => 'Title harus diisi!',
                'title.string' => 'Title diperbolehkan hanya string!',
                'text.required' => 'Text harus diisi!',
                'text.string' => 'Text diperbolehkan hanya string!'
            ]);
            $running = RunningText::findOrFail($id);
            $data = array(
            'title' => $request->title,
            'text' => $request->text,
            'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $running->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate runningtext : ".$running->title);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate running text!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function update_status(Request $request){
        try {
            $id = $request->id;
            $running = RunningText::findOrFail($id);
            if($running->status == 0){
                $data = array('status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }else{
                $data = array('status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }
            $running->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate status runningtext : ".$running->title);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate status running text!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function remove(Request $request)
    {
        try {
            $id = $request->input('id');
            $running = RunningText::findOrFail($id);
            $running->delete();
            \Helper::log(\Auth::user()->username, "Menghapus runningtext : ".$running->title);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus running text!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
}
